/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlGroup;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.Tab;

public class ControlEvent {
    public static int UNDEFINDED = -1;
    public static int CONTROLLER = 0;
    public static int TAB = 1;
    public static int GROUP = 2;
    protected final ControllerInterface<?> _myController;
    protected boolean isTab;
    protected boolean isController;
    protected boolean isGroup;
    protected int myAction;

    protected ControlEvent(Controller<?> controller) {
        this._myController = controller;
        this.isTab = false;
        this.isController = true;
        this.isGroup = false;
    }

    public ControlEvent(Tab tab) {
        this._myController = tab;
        this.isTab = true;
        this.isGroup = false;
        this.isController = false;
    }

    public ControlEvent(ControllerGroup<?> controllerGroup) {
        this._myController = controllerGroup;
        this.isTab = false;
        this.isGroup = true;
        this.isController = false;
    }

    public float getValue() {
        return this._myController.getValue();
    }

    public String getStringValue() {
        return ((Controller)this._myController).getStringValue();
    }

    public float[] getArrayValue() {
        return this._myController.getArrayValue();
    }

    public float getArrayValue(int n) {
        return this._myController.getArrayValue()[n];
    }

    public Controller<?> getController() {
        return (Controller)this._myController;
    }

    public Tab getTab() {
        return (Tab)this._myController;
    }

    public ControlGroup<?> getGroup() {
        return (ControlGroup)this._myController;
    }

    public String getLabel() {
        return ((Controller)this._myController).getLabel();
    }

    public boolean isTab() {
        return this.isTab;
    }

    public boolean isController() {
        return this.isController;
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public String getName() {
        return this._myController.getName();
    }

    public int getId() {
        return this._myController.getId();
    }

    public int getType() {
        if (this.isController) {
            return CONTROLLER;
        }
        if (this.isTab) {
            return TAB;
        }
        if (this.isGroup) {
            return GROUP;
        }
        return -1;
    }

    public boolean isFrom(ControllerInterface<?> controllerInterface) {
        return this._myController.equals(controllerInterface);
    }

    public boolean isFrom(String string) {
        return this._myController.getName().equals(string);
    }

    public boolean isAssignableFrom(Class<?> clazz) {
        return this._myController.getClass().isAssignableFrom(clazz);
    }

    @Deprecated
    public int type() {
        return this.getType();
    }

    @Deprecated
    public int id() {
        return this.getId();
    }

    @Deprecated
    public String name() {
        return this.getName();
    }

    @Deprecated
    public String label() {
        return this.getLabel();
    }

    @Deprecated
    public float value() {
        return this.getValue();
    }

    @Deprecated
    public String stringValue() {
        return this.getStringValue();
    }

    @Deprecated
    public float[] arrayValue() {
        return this.getArrayValue();
    }

    @Deprecated
    public Controller<?> controller() {
        return this.getController();
    }

    @Deprecated
    public ControlGroup<?> group() {
        return this.getGroup();
    }

    @Deprecated
    public Tab tab() {
        return this.getTab();
    }

    public String toString() {
        return "[ ControlEvent from:" + this._myController.getClass().getSimpleName() + " value:" + this.getValue() + " name:" + this.getName() + " ]";
    }
}

