/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Accordion;
import controlP5.Bang;
import controlP5.Button;
import controlP5.ButtonBar;
import controlP5.CColor;
import controlP5.Chart;
import controlP5.CheckBox;
import controlP5.ColorPicker;
import controlP5.ColorWheel;
import controlP5.ControlKey;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.ControlP5Legacy;
import controlP5.Controller;
import controlP5.ControllerAutomator;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerLayout;
import controlP5.ControllerProperties;
import controlP5.FieldChangedListener;
import controlP5.FrameRate;
import controlP5.Group;
import controlP5.Knob;
import controlP5.Matrix;
import controlP5.MultiList;
import controlP5.Numberbox;
import controlP5.Println;
import controlP5.RadioButton;
import controlP5.Range;
import controlP5.ScrollableList;
import controlP5.Slider;
import controlP5.Slider2D;
import controlP5.Tab;
import controlP5.Textarea;
import controlP5.Textfield;
import controlP5.Textlabel;
import controlP5.Toggle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import processing.core.PApplet;

public class ControlP5Base
extends ControlP5Legacy
implements ControlP5Constants {
    protected ControlP5 cp5;
    protected ControllerProperties _myProperties;
    private ControllerAutomator _myAutomator;
    protected Map<Object, ArrayList<ControllerInterface<?>>> _myObjectToControllerMap = new HashMap();
    protected Map<String, FieldChangedListener> _myFieldChangedListenerMap = new HashMap<String, FieldChangedListener>();
    protected Map<KeyCode, List<ControlKey>> keymap = new HashMap<KeyCode, List<ControlKey>>();
    protected ControllerGroup<?> currentGroupPointer;
    protected boolean isCurrentGroupPointerClosed = true;
    protected int autoDirection = 0;
    protected int modifiers;

    public Tab getDefaultTab() {
        return (Tab)this.cp5.controlWindow.getTabs().get(1);
    }

    protected void init(ControlP5 controlP5) {
        super.init(controlP5);
        this.cp5 = controlP5;
        this._myProperties = new ControllerProperties(this.cp5);
        this._myAutomator = new ControllerAutomator(this.cp5);
        this.currentGroupPointer = this.cp5.controlWindow.getTab("default");
    }

    public ControllerLayout getLayout() {
        return new ControllerLayout(this.cp5);
    }

    public Tab addTab(String string) {
        for (int i = 0; i < this.cp5.getWindow().getTabs().size(); ++i) {
            if (!this.cp5.getWindow().getTabs().get(i).getName().equals(string)) continue;
            return (Tab)this.cp5.getWindow().getTabs().get(i);
        }
        Tab tab = new Tab(this.cp5, this.cp5.getWindow(), string);
        this.cp5.getWindow().getTabs().add(tab);
        return tab;
    }

    public Bang addBang(String string) {
        return this.addBang(null, string);
    }

    public Bang addBang(Object object, String string) {
        return this.addBang(object, object != null ? object.toString() : "", string);
    }

    public Button addButton(String string) {
        return this.addButton(null, string);
    }

    public Button addButton(Object object, String string) {
        return this.addButton(object, object != null ? object.toString() : "", string, 1.0f);
    }

    public ButtonBar addButtonBar(String string) {
        return this.addButtonBar(null, string);
    }

    public ButtonBar addButtonBar(Object object, String string) {
        return this.addButtonBar(object, object != null ? object.toString() : "", string, 1.0f);
    }

    public Toggle addToggle(Object object, String string) {
        return this.addToggle(object, object != null ? object.toString() : "", string);
    }

    public Toggle addToggle(String string) {
        return this.addToggle(null, string);
    }

    public Slider addSlider(String string) {
        return this.addSlider(null, string);
    }

    public Slider addSlider(Object object, String string) {
        return this.addSlider(object, object != null ? object.toString() : "", string);
    }

    public Range addRange(String string) {
        return this.addRange(string, 0.0f, 100.0f, 0.0f, 100.0f, 0, 0, 100, 10);
    }

    public Range addRange(Object object, String string) {
        return this.addRange(object, object != null ? object.toString() : "", string, 0.0f, 100.0f, 0.0f, 100.0f, 0, 0, 100, 10);
    }

    public Numberbox addNumberbox(String string) {
        return this.addNumberbox(null, string);
    }

    public Numberbox addNumberbox(Object object, String string) {
        return this.addNumberbox(object, object != null ? object.toString() : "", string);
    }

    public Knob addKnob(String string) {
        return this.addKnob(string, 0, 100);
    }

    public Knob addKnob(Object object, String string) {
        return this.addKnob(object, object != null ? object.toString() : "", string);
    }

    public Matrix addMatrix(String string) {
        return this.addMatrix(string, 10, 10, 0, 0, 100, 100);
    }

    public Matrix addMatrix(Object object, String string) {
        return this.addMatrix(object, object != null ? object.toString() : "", string, 10, 10, 0, 0, 100, 100);
    }

    public Slider2D addSlider2D(String string) {
        return this.addSlider2D(null, string);
    }

    public Slider2D addSlider2D(Object object, String string) {
        return this.addSlider2D(object, object != null ? object.toString() : "", string, 0.0f, 100.0f, 0.0f, 100.0f, 0.0f, 0.0f, 0, 0, 100, 100);
    }

    public Textlabel addTextlabel(String string) {
        return this.addTextlabel(string, "", 0, 0);
    }

    public Textarea addTextarea(String string) {
        return this.addTextarea(string, "", 0, 0, 200, 100);
    }

    public Textfield addTextfield(String string) {
        return this.addTextfield(string, 0, 0, 200, 20);
    }

    public Textfield addTextfield(Object object, String string) {
        return this.addTextfield(object, object != null ? object.toString() : "", string, 0, 0, 200, 20);
    }

    public RadioButton addRadioButton(String string) {
        return this.addRadioButton(null, string);
    }

    public RadioButton addRadioButton(Object object, String string) {
        return this.addRadioButton(object, object != null ? object.toString() : "", string, 0, 0);
    }

    public CheckBox addCheckBox(String string) {
        return this.addCheckBox(string, 0, 0);
    }

    public CheckBox addCheckBox(Object object, String string) {
        return this.addCheckBox(object, object != null ? object.toString() : "", string, 0, 0);
    }

    public ScrollableList addScrollableList(String string) {
        return this.addScrollableList(string, 0, 0, 100, 200);
    }

    public ScrollableList addScrollableList(Object object, String string) {
        return this.addScrollableList(object, object != null ? object.toString() : "", string, 0, 0, 100, 100);
    }

    public MultiList addMultiList(String string) {
        return this.addMultiList(null, string);
    }

    public MultiList addMultiList(Object object, String string) {
        return this.addMultiList(object, object != null ? object.toString() : "", string, 0, 0, 100, 100);
    }

    public ColorWheel addColorWheel(String string) {
        return this.addColorWheel(null, string);
    }

    public ColorWheel addColorWheel(Object object, String string) {
        return this.addColorWheel(object, object != null ? object.toString() : "", string, 0, 0, 200);
    }

    public ColorPicker addColorPicker(String string) {
        return this.addColorPicker(null, string);
    }

    public ColorPicker addColorPicker(Object object, String string) {
        return this.addColorPicker(object, object != null ? object.toString() : "", string, 0, 0, 255, 10);
    }

    public Println addConsole(Textarea textarea) {
        return new Println(textarea);
    }

    public FrameRate addFrameRate() {
        FrameRate frameRate = new FrameRate(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), "-", 0, 4);
        this.cp5.register(null, "", frameRate);
        return frameRate;
    }

    public Chart addChart(String string) {
        return this.addChart(string, 0, 0, 200, 100);
    }

    public Group addGroup(String string) {
        return this.addGroup(string, 0, 0);
    }

    public Group addGroup(Object object, String string) {
        return this.addGroup(object, object != null ? object.toString() : "", string);
    }

    public Accordion addAccordion(String string) {
        return this.addAccordion(null, "", string);
    }

    public Accordion addAccordion(Object object, String string) {
        return this.addAccordion(object, object != null ? object.toString() : "", string);
    }

    protected void setCurrentPointer(ControllerGroup<?> controllerGroup) {
        this.currentGroupPointer = controllerGroup;
        this.isCurrentGroupPointerClosed = false;
    }

    protected void releaseCurrentPointer(ControllerGroup<?> controllerGroup) {
        if (!this.isCurrentGroupPointerClosed) {
            this.currentGroupPointer = controllerGroup;
            this.isCurrentGroupPointerClosed = true;
        } else {
            ControlP5.logger().warning("use .end() first before using .begin() again.");
        }
    }

    public void setAutoAddDirection(int n) {
        if (n == 0) {
            this.autoDirection = 0;
            return;
        }
        this.autoDirection = 1;
    }

    public void setAutoSpacing() {
        Controller.set(Controller.autoSpacing, 10.0f, 10.0f);
    }

    public void setAutoSpacing(float f, float f2) {
        Controller.set(Controller.autoSpacing, f, f2);
    }

    public void setAutoSpacing(float f, float f2, float f3) {
        this.setAutoSpacing(f, f2);
    }

    protected void linebreak(Controller<?> controller, boolean bl, int n, int n2, float[] fArray) {
        float f;
        float f2;
        if (Controller.x(this.currentGroupPointer.autoPosition) + Controller.x(Controller.autoSpacing) + (float)n > (float)this.cp5.papplet.width) {
            f2 = Controller.x(this.currentGroupPointer.autoPosition) + this.currentGroupPointer.autoPositionOffsetX;
            f = Controller.y(this.currentGroupPointer.autoPosition) + this.currentGroupPointer.tempAutoPositionHeight;
            Controller.set(this.currentGroupPointer.autoPosition, f2, f);
            this.currentGroupPointer.tempAutoPositionHeight = 0.0f;
            Controller.set(controller.position, Controller.x(this.currentGroupPointer.autoPosition), Controller.y(this.currentGroupPointer.autoPosition));
            bl = false;
        }
        if (bl) {
            f2 = Controller.y(this.currentGroupPointer.autoPosition) + this.currentGroupPointer.tempAutoPositionHeight;
            Controller.set(this.currentGroupPointer.autoPosition, this.currentGroupPointer.autoPositionOffsetX, f2);
            this.currentGroupPointer.tempAutoPositionHeight = 0.0f;
        } else {
            if (controller instanceof Slider) {
                f2 = Controller.x(this.currentGroupPointer.autoPosition) + (float)controller.getCaptionLabel().getWidth();
                f = Controller.y(this.currentGroupPointer.autoPosition);
                Controller.set(this.currentGroupPointer.autoPosition, f2, f);
            }
            f2 = Controller.x(this.currentGroupPointer.autoPosition) + Controller.x(Controller.autoSpacing) + (float)n;
            f = Controller.y(this.currentGroupPointer.autoPosition);
            Controller.set(this.currentGroupPointer.autoPosition, f2, f);
            if ((float)n2 + Controller.y(fArray) > this.currentGroupPointer.tempAutoPositionHeight) {
                this.currentGroupPointer.tempAutoPositionHeight = (float)n2 + Controller.y(fArray);
            }
        }
    }

    public ControlP5Base addControllersFor(PApplet pApplet) {
        this.addControllersFor("", pApplet);
        return this.cp5;
    }

    public ControlP5Base addControllersFor(String string, Object object) {
        this._myAutomator.addControllersFor(string, object);
        return this.cp5;
    }

    public Object getObjectForController(ControllerInterface controllerInterface) {
        for (Map.Entry<Object, ArrayList<ControllerInterface<?>>> entry : this._myObjectToControllerMap.entrySet()) {
            Object object = entry.getKey();
            ArrayList<ControllerInterface<?>> arrayList = entry.getValue();
            for (ControllerInterface<?> controllerInterface2 : arrayList) {
                if (!controllerInterface2.equals(controllerInterface)) continue;
                return object;
            }
        }
        return null;
    }

    public ControlP5Base setPosition(int n, int n2, Object object) {
        if (object != null && this._myObjectToControllerMap.containsKey(object)) {
            ArrayList<ControllerInterface<?>> arrayList = this._myObjectToControllerMap.get(object);
            for (ControllerInterface<?> controllerInterface : arrayList) {
                int n3 = (int)Controller.x(controllerInterface.getPosition()) + n;
                int n4 = (int)Controller.y(controllerInterface.getPosition()) + n2;
                controllerInterface.setPosition(n3, n4);
            }
        }
        return this.cp5;
    }

    public ControlP5Base hide(Object object) {
        if (object != null && this._myObjectToControllerMap.containsKey(object)) {
            ArrayList<ControllerInterface<?>> arrayList = this._myObjectToControllerMap.get(object);
            for (ControllerInterface<?> controllerInterface : arrayList) {
                controllerInterface.hide();
            }
        }
        return this.cp5;
    }

    public ControlP5Base show(Object object) {
        if (object != null && this._myObjectToControllerMap.containsKey(object)) {
            ArrayList<ControllerInterface<?>> arrayList = this._myObjectToControllerMap.get(object);
            for (ControllerInterface<?> controllerInterface : arrayList) {
                controllerInterface.show();
            }
        }
        return this.cp5;
    }

    public ControlP5Base remove(Object object) {
        if (object != null && this._myObjectToControllerMap.containsKey(object)) {
            ArrayList<ControllerInterface<?>> arrayList = this._myObjectToControllerMap.get(object);
            for (ControllerInterface<?> controllerInterface : arrayList) {
                controllerInterface.remove();
            }
        }
        return this.cp5;
    }

    public ControlP5Base setColor(CColor cColor, Object object) {
        if (this._myObjectToControllerMap.containsKey(object)) {
            ArrayList<ControllerInterface<?>> arrayList = this._myObjectToControllerMap.get(object);
            for (ControllerInterface<?> controllerInterface : arrayList) {
                controllerInterface.setColor(cColor);
            }
        }
        return this.cp5;
    }

    public ControlP5Base listenTo(String string, Object object) {
        String string2 = object.hashCode() + "" + string.hashCode();
        FieldChangedListener fieldChangedListener = new FieldChangedListener(this.cp5);
        fieldChangedListener.listenTo(object, string);
        this._myFieldChangedListenerMap.put(string2, fieldChangedListener);
        return this.cp5;
    }

    public ControlP5Base stopListeningTo(String string, Object object) {
        String string2 = object.hashCode() + "" + string.hashCode();
        this._myFieldChangedListenerMap.remove(string2);
        return this.cp5;
    }

    public ControlP5Base moveTo(ControllerGroup<?> controllerGroup, Object object) {
        if (this._myObjectToControllerMap.containsKey(object)) {
            ArrayList<ControllerInterface<?>> arrayList = this._myObjectToControllerMap.get(object);
            for (ControllerInterface<?> controllerInterface : arrayList) {
                controllerInterface.moveTo(controllerGroup);
            }
        }
        return this.cp5;
    }

    public ControllerProperties getProperties() {
        return this._myProperties;
    }

    public void removeProperty(ControllerInterface<?> controllerInterface) {
        this._myProperties.remove(controllerInterface);
    }

    public static void printPublicMethodsFor(Class<?> clazz, String ... stringArray) {
        Set<String> set = ControlP5Base.getPublicMethodsFor(clazz, true, stringArray);
        String string = "";
        string = string + "/**\n";
        string = string + "* ControlP5 " + clazz.getSimpleName() + "\n";
        string = string + "*\n";
        string = string + "*\n";
        string = string + "* find a list of public methods available for the " + clazz.getSimpleName() + " Controller\n";
        string = string + "* at the bottom of this sketch.\n";
        string = string + "*\n";
        string = string + "* by Andreas Schlegel, 2012\n";
        string = string + "* www.sojamo.de/libraries/controlp5\n";
        string = string + "*\n";
        string = string + "*/\n\n";
        string = string + "/*\n";
        string = string + "a list of all methods available for the " + clazz.getSimpleName() + " Controller\n";
        string = string + "use ControlP5.printPublicMethodsFor(" + clazz.getSimpleName() + ".class);\n";
        string = string + "to print the following list into the console.\n\n";
        string = string + "You can find further details about class " + clazz.getSimpleName() + " in the javadoc.\n\n";
        string = string + "Format:\n";
        string = string + "ClassName : returnType methodName(parameter type)\n\n\n";
        for (String string2 : set) {
            string = string + string2 + "\n";
        }
        string = string + "\n\n*/\n\n";
        ControlP5Base.println(string);
    }

    public static void printPublicMethodsFor(Class<?> clazz) {
        ControlP5Base.printPublicMethodsFor(clazz, "");
    }

    public static Set<String> getPublicMethodsFor(Class<?> clazz) {
        return ControlP5Base.getPublicMethodsFor(clazz, true, "");
    }

    public static Set<String> getPublicMethodsFor(Class<?> clazz, String ... stringArray) {
        return ControlP5Base.getPublicMethodsFor(clazz, true, stringArray);
    }

    public static Set<String> getPublicMethodsFor(Class<?> clazz, boolean bl) {
        return ControlP5Base.getPublicMethodsFor(clazz, true, "");
    }

    public static Set<String> getPublicMethodsFor(Class<?> clazz, boolean bl, String ... stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Class<?> clazz2 = clazz;
        while (clazz2 != null) {
            for (Method method : clazz2.getDeclaredMethods()) {
                if (method.isAnnotationPresent(Deprecated.class) || method.isAnnotationPresent(ControlP5.Invisible.class) || method.getModifiers() != 1) continue;
                for (String string : stringArray) {
                    if (string.length() > 0 && !method.getName().toLowerCase().contains(string.toLowerCase())) continue;
                    String string2 = "";
                    for (Class<?> clazz3 : method.getParameterTypes()) {
                        string2 = string2 + clazz3.getSimpleName() + ", ";
                    }
                    if (string2.length() > 0) {
                        string2 = string2.substring(0, string2.length() - 2);
                    }
                    treeSet.add(clazz2.getCanonicalName() + " : " + method.getReturnType().getSimpleName().replace("Object", clazz.getSimpleName()) + " " + method.getName() + "(" + string2 + ") ");
                }
            }
            if (bl) {
                clazz2 = clazz2.getSuperclass();
                continue;
            }
            clazz2 = null;
        }
        return treeSet;
    }

    public int getKeyCode() {
        return this.cp5.getWindow().keyCode;
    }

    public char getKey() {
        return this.cp5.getWindow().key;
    }

    private char[] fromIntToChar(int ... nArray) {
        char[] cArray = new char[nArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            if (nArray[i] >= 97 && nArray[i] <= 122) {
                int n = i;
                nArray[n] = nArray[n] - 32;
            }
            cArray[i] = (char)nArray[i];
        }
        return cArray;
    }

    public ControlP5 removeKeyFor(ControlKey controlKey, int ... nArray) {
        this.removeKeyFor(controlKey, this.fromIntToChar(nArray));
        return this.cp5;
    }

    public ControlP5 mapKeyFor(ControlKey controlKey, Object ... objectArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Object[] objectArray2 = objectArray;
        int keyCode = objectArray2.length;
        for (int i = 0; i < keyCode; ++i) {
            Object object = objectArray2[i];
            if (object instanceof Integer) {
                arrayList.add((Integer)object);
                continue;
            }
            if (!(object instanceof Character)) continue;
            char c = ((Character)object).charValue();
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            arrayList.add(Integer.valueOf(c));
        }
        char[] cArray = new char[arrayList.size()];
        for (keyCode = 0; keyCode < arrayList.size(); ++keyCode) {
            cArray[keyCode] = (char)((Integer)arrayList.get(keyCode)).intValue();
        }
        KeyCode keyCode2 = new KeyCode(cArray);
        if (!this.keymap.containsKey(keyCode2)) {
            this.keymap.put(keyCode2, new ArrayList());
        }
        this.keymap.get(keyCode2).add(controlKey);
        this.cp5.enableShortcuts();
        return this.cp5;
    }

    public ControlP5 removeKeyFor(ControlKey controlKey, char ... cArray) {
        List<ControlKey> list = this.keymap.get(new KeyCode(cArray));
        if (list != null) {
            list.remove(controlKey);
        }
        return this.cp5;
    }

    public ControlP5 removeKeysFor(char ... cArray) {
        this.keymap.remove(new KeyCode(cArray));
        return this.cp5;
    }

    public ControlP5 removeKeysFor(int ... nArray) {
        this.removeKeysFor(this.fromIntToChar(nArray));
        return this.cp5;
    }

    public boolean isShiftDown() {
        return (this.modifiers & 1 & (this.cp5.isShortcuts() ? -1 : 1)) != 0;
    }

    public boolean isControlDown() {
        return (this.modifiers & 2 & (this.cp5.isShortcuts() ? -1 : 1)) != 0;
    }

    public boolean isMetaDown() {
        return (this.modifiers & 4 & (this.cp5.isShortcuts() ? -1 : 1)) != 0;
    }

    public boolean isAltDown() {
        return (this.modifiers & 8 & (this.cp5.isShortcuts() ? -1 : 1)) != 0;
    }

    static class KeyCode {
        final char[] chars;

        KeyCode(char ... cArray) {
            this.chars = cArray;
            Arrays.sort(this.chars);
        }

        public String toString() {
            String string = "";
            for (char c : this.chars) {
                string = string + c + "(" + c + ") ";
            }
            return string;
        }

        public int size() {
            return this.chars.length;
        }

        public char[] getChars() {
            return this.chars;
        }

        public char get(int n) {
            if (n >= 0 && n < this.size()) {
                return this.chars[n];
            }
            return '\u0000';
        }

        public boolean equals(Object object) {
            if (!(object instanceof KeyCode)) {
                return false;
            }
            KeyCode keyCode = (KeyCode)object;
            if (keyCode.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == keyCode.get(i)) continue;
                return false;
            }
            return true;
        }

        boolean contains(char c) {
            for (char c2 : this.chars) {
                if (c != c2) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            int n2 = 1;
            for (char c : this.chars) {
                n = (int)((double)n + ((double)c + Math.pow(c, n2++)));
            }
            return n;
        }
    }
}

