/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import processing.core.PGraphics;

public class Button
extends Controller<Button> {
    protected boolean isPressed;
    protected boolean isOn = false;
    public static int autoWidth = 69;
    public static int autoHeight = 19;
    protected int activateBy = 2;
    protected boolean isSwitch = false;

    public Button(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0.0f, 0, 0, autoWidth, autoHeight);
        controlP5.register(controlP5.papplet, string, this);
    }

    protected Button(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, float f, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myValue = f;
        this._myCaptionLabel.align(3, 3);
    }

    public Button() {
        super(null, null, null, 0.0f, 0.0f, 1, 1);
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
    }

    @Override
    protected void onLeave() {
        this.isActive = false;
        this.setIsInside(false);
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        this.isActive = this.getIsInside();
        this.isPressed = true;
        if (this.activateBy == 1) {
            this.activate();
        }
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleased() {
        this.isPressed = false;
        if (this.activateBy == 2) {
            this.activate();
        }
        this.isActive = false;
    }

    public Button activateBy(int n) {
        this.activateBy = n == 1 ? 1 : 2;
        return this;
    }

    protected void activate() {
        if (this.isActive) {
            this.isActive = false;
            this.isOn = !this.isOn;
            this.setValue(this._myValue);
        }
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    @Override
    public Button setValue(float f) {
        this._myValue = f;
        this.broadcast(2);
        return this;
    }

    @Override
    public Button update() {
        return this.setValue(this._myValue);
    }

    public Button setSwitch(boolean bl) {
        this.isSwitch = bl;
        this._myBroadcastType = this.isSwitch ? 3 : 2;
        return this;
    }

    public Button setOn() {
        if (this.isSwitch) {
            this.isOn = false;
            this.isActive = true;
            this.activate();
        }
        return this;
    }

    public Button setOff() {
        if (this.isSwitch) {
            this.isOn = true;
            this.isActive = true;
            this.activate();
        }
        return this;
    }

    public boolean isOn() {
        return this.isOn;
    }

    public boolean isSwitch() {
        return this.isSwitch;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public boolean getBooleanValue() {
        return this.isOn;
    }

    @Override
    @ControlP5.Invisible
    public Button updateDisplayMode(int n) {
        return this.updateViewMode(n);
    }

    @ControlP5.Invisible
    public Button updateViewMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = new ButtonView();
                break;
            }
            case 1: {
                this._myControllerView = new ButtonImageView();
                break;
            }
        }
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tButton\n" + super.getInfo();
    }

    @Override
    public String toString() {
        return super.toString() + " [ " + this.getValue() + " ] " + "Button" + " (" + this.getClass().getSuperclass() + ")";
    }

    private class ButtonImageView
    implements ControllerView<Button> {
        private ButtonImageView() {
        }

        @Override
        public void display(PGraphics pGraphics, Button button) {
            if (Button.this.isOn && Button.this.isSwitch) {
                pGraphics.image(Button.this.availableImages[3] ? Button.this.images[3] : Button.this.images[0], 0.0f, 0.0f);
                return;
            }
            if (Button.this.getIsInside()) {
                if (Button.this.isPressed) {
                    pGraphics.image(Button.this.availableImages[2] ? Button.this.images[2] : Button.this.images[0], 0.0f, 0.0f);
                } else {
                    pGraphics.image(Button.this.availableImages[1] ? Button.this.images[1] : Button.this.images[0], 0.0f, 0.0f);
                }
            } else {
                pGraphics.image(Button.this.images[0], 0.0f, 0.0f);
            }
        }
    }

    private class ButtonView
    implements ControllerView<Button> {
        private ButtonView() {
        }

        @Override
        public void display(PGraphics pGraphics, Button button) {
            pGraphics.noStroke();
            if (Button.this.isOn && Button.this.isSwitch) {
                pGraphics.fill(Button.this.color.getActive());
            } else if (Button.this.getIsInside()) {
                if (Button.this.isPressed) {
                    pGraphics.fill(Button.this.color.getActive());
                } else {
                    pGraphics.fill(Button.this.color.getForeground());
                }
            } else {
                pGraphics.fill(Button.this.color.getBackground());
            }
            pGraphics.rect(0.0f, 0.0f, (float)Button.this.getWidth(), (float)Button.this.getHeight());
            if (Button.this.isLabelVisible) {
                Button.this._myCaptionLabel.draw(pGraphics, 0, 0, button);
            }
        }
    }
}

