/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.FieldValue;
import java.lang.reflect.Field;

class FieldChangedListener {
    private FieldValue value;
    private ControlP5 controlP5;

    public FieldChangedListener(ControlP5 controlP5) {
        this.controlP5 = controlP5;
    }

    public void listenTo(final Object object, final String string) {
        try {
            Class<?> clazz = object.getClass();
            final Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            if (field.getType().isAssignableFrom(Float.TYPE)) {
                this.value = new FieldValue(){
                    float then;

                    @Override
                    public void check() {
                        try {
                            float f = ((Float)field.get(object)).floatValue();
                            if (f != this.then) {
                                FieldChangedListener.this.controlP5.getController(string, object).setValue(f);
                                this.then = f;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                };
            } else if (field.getType().isAssignableFrom(Integer.TYPE)) {
                this.value = new FieldValue(){
                    int then;

                    @Override
                    public void check() {
                        try {
                            int n = (Integer)field.get(object);
                            if (n != this.then) {
                                FieldChangedListener.this.controlP5.getController(string, object).setValue(n);
                                this.then = n;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                };
            } else if (field.getType().isAssignableFrom(Boolean.TYPE)) {
                this.value = new FieldValue(){
                    boolean then;

                    @Override
                    public void check() {
                        try {
                            boolean bl = (Boolean)field.get(object);
                            if (bl != this.then) {
                                FieldChangedListener.this.controlP5.getController(string, object).setValue(bl ? 1.0f : 0.0f);
                                this.then = bl;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                };
            } else if (field.getType().isAssignableFrom(String.class)) {
                this.value = new FieldValue(){
                    String then;

                    @Override
                    public void check() {
                        try {
                            String string2 = (String)field.get(object);
                            if (!string2.equals(this.then)) {
                                FieldChangedListener.this.controlP5.getController(string, object).setStringValue(string2);
                                this.then = string2;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                };
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    void update() {
        this.value.check();
    }
}

