/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CP;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerInterface;
import controlP5.ControllerProperty;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import processing.core.PApplet;
import processing.data.JSONArray;
import processing.data.JSONObject;

public class ControllerProperties {
    public static final int OPEN = 0;
    public static final int CLOSE = 1;
    public static String defaultName = "controlP5";
    PropertiesStorageFormat format;
    private Map<ControllerProperty, HashSet<String>> allProperties;
    private Set<String> allSets;
    final ControlP5 controlP5;
    private String _myDefaultSetName = "default";
    public static final Logger logger = Logger.getLogger(ControllerProperties.class.getName());
    private Map<String, Set<ControllerProperty>> _mySnapshots;

    public ControllerProperties(ControlP5 controlP5) {
        this.controlP5 = controlP5;
        this.setFormat(new JSONFormat());
        this.allProperties = new HashMap<ControllerProperty, HashSet<String>>();
        this.allSets = new HashSet<String>();
        this.addSet(this._myDefaultSetName);
        this._mySnapshots = new LinkedHashMap<String, Set<ControllerProperty>>();
    }

    public Map<ControllerProperty, HashSet<String>> get() {
        return this.allProperties;
    }

    public ControllerProperty register(ControllerInterface<?> controllerInterface, String string, String string2) {
        ControllerProperty controllerProperty = new ControllerProperty(controllerInterface, string, string2);
        if (!this.allProperties.containsKey(controllerProperty)) {
            this.allProperties.put(controllerProperty, new HashSet());
            this.allProperties.get(controllerProperty).add(this._myDefaultSetName);
        }
        return controllerProperty;
    }

    public ControllerProperties register(ControllerInterface<?> controllerInterface, String string) {
        string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        this.register(controllerInterface, "set" + string, "get" + string);
        return this;
    }

    public ControllerProperties remove(ControllerInterface<?> controllerInterface, String string, String string2) {
        ControllerProperty controllerProperty = new ControllerProperty(controllerInterface, string, string2);
        this.allProperties.remove(controllerProperty);
        return this;
    }

    public ControllerProperties remove(ControllerInterface<?> controllerInterface) {
        ArrayList<ControllerProperty> arrayList = new ArrayList<ControllerProperty>(this.allProperties.keySet());
        for (ControllerProperty controllerProperty : arrayList) {
            if (!controllerProperty.getController().equals(controllerInterface)) continue;
            this.allProperties.remove(controllerProperty);
        }
        return this;
    }

    public ControllerProperties remove(ControllerInterface<?> controllerInterface, String string) {
        return this.remove(controllerInterface, "set" + string, "get" + string);
    }

    public List<ControllerProperty> get(ControllerInterface<?> controllerInterface) {
        ArrayList<ControllerProperty> arrayList = new ArrayList<ControllerProperty>();
        ArrayList<ControllerProperty> arrayList2 = new ArrayList<ControllerProperty>(this.allProperties.keySet());
        for (ControllerProperty controllerProperty : arrayList2) {
            if (!controllerProperty.getController().equals(controllerInterface)) continue;
            arrayList.add(controllerProperty);
        }
        return arrayList;
    }

    public ControllerProperty getProperty(ControllerInterface<?> controllerInterface, String string, String string2) {
        ControllerProperty controllerProperty = new ControllerProperty(controllerInterface, string, string2);
        for (ControllerProperty controllerProperty2 : this.allProperties.keySet()) {
            if (!controllerProperty2.equals(controllerProperty)) continue;
            return controllerProperty2;
        }
        return this.register(controllerInterface, string, string2);
    }

    public ControllerProperty getProperty(ControllerInterface<?> controllerInterface, String string) {
        string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        return this.getProperty(controllerInterface, "set" + string, "get" + string);
    }

    public HashSet<ControllerProperty> getPropertySet(ControllerInterface<?> controllerInterface) {
        HashSet<ControllerProperty> hashSet = new HashSet<ControllerProperty>();
        for (ControllerProperty controllerProperty : this.allProperties.keySet()) {
            if (!controllerProperty.getController().equals(controllerInterface)) continue;
            hashSet.add(controllerProperty);
        }
        return hashSet;
    }

    public ControllerProperties addSet(String string) {
        this.allSets.add(string);
        return this;
    }

    public ControllerProperties move(ControllerProperty controllerProperty, String string, String string2) {
        if (!this.exists(controllerProperty)) {
            return this;
        }
        if (this.allProperties.containsKey(controllerProperty)) {
            if (this.allProperties.get(controllerProperty).contains(string)) {
                this.allProperties.get(controllerProperty).remove(string);
            }
            this.addSet(string2);
            this.allProperties.get(controllerProperty).add(string2);
        }
        return this;
    }

    public ControllerProperties move(ControllerInterface<?> controllerInterface, String string, String string2) {
        HashSet<ControllerProperty> hashSet = this.getPropertySet(controllerInterface);
        for (ControllerProperty controllerProperty : hashSet) {
            this.move(controllerProperty, string, string2);
        }
        return this;
    }

    public ControllerProperties copy(ControllerProperty controllerProperty, String ... stringArray) {
        if (!this.exists(controllerProperty)) {
            return this;
        }
        for (String string : stringArray) {
            this.allProperties.get(controllerProperty).add(string);
            if (this.allSets.contains(string)) continue;
            this.addSet(string);
        }
        return this;
    }

    public ControllerProperties copy(ControllerInterface<?> controllerInterface, String ... stringArray) {
        HashSet<ControllerProperty> hashSet = this.getPropertySet(controllerInterface);
        for (ControllerProperty controllerProperty : hashSet) {
            this.copy(controllerProperty, stringArray);
        }
        return this;
    }

    public ControllerProperties remove(ControllerProperty controllerProperty, String ... stringArray) {
        if (!this.exists(controllerProperty)) {
            return this;
        }
        for (String string : stringArray) {
            this.allProperties.get(controllerProperty).remove(string);
        }
        return this;
    }

    public ControllerProperties remove(ControllerInterface<?> controllerInterface, String ... stringArray) {
        HashSet<ControllerProperty> hashSet = this.getPropertySet(controllerInterface);
        for (ControllerProperty controllerProperty : hashSet) {
            this.remove(controllerProperty, stringArray);
        }
        return this;
    }

    public ControllerProperties only(ControllerProperty controllerProperty, String string) {
        this.allProperties.get(controllerProperty).clear();
        this.allProperties.get(controllerProperty).add(string);
        return this;
    }

    ControllerProperties only(ControllerInterface<?> controllerInterface, String ... stringArray) {
        return this;
    }

    private boolean exists(ControllerProperty controllerProperty) {
        return this.allProperties.containsKey(controllerProperty);
    }

    public ControllerProperties print() {
        for (Map.Entry<ControllerProperty, HashSet<String>> entry : this.allProperties.entrySet()) {
            System.out.println(entry.getKey() + "\t" + entry.getValue());
        }
        return this;
    }

    public ControllerProperties delete(ControllerProperty controllerProperty) {
        if (!this.exists(controllerProperty)) {
            return this;
        }
        this.allProperties.remove(controllerProperty);
        return this;
    }

    private boolean updatePropertyValue(ControllerProperty controllerProperty) {
        try {
            Method method = controllerProperty.getController().getClass().getMethod(controllerProperty.getGetter(), new Class[0]);
            Object object = method.invoke(controllerProperty.getController(), new Object[0]);
            controllerProperty.setType(method.getReturnType());
            controllerProperty.setValue(object);
            if (this.checkSerializable(object)) {
                return true;
            }
        }
        catch (Exception exception) {
            logger.severe("" + exception);
        }
        return false;
    }

    private boolean checkSerializable(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ControllerProperties setSnapshot(String string) {
        HashSet<ControllerProperty> hashSet = new HashSet<ControllerProperty>();
        for (ControllerProperty controllerProperty : this.allProperties.keySet()) {
            this.updatePropertyValue(controllerProperty);
            try {
                hashSet.add((ControllerProperty)controllerProperty.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        this._mySnapshots.put(string, hashSet);
        return this;
    }

    public ControllerProperties updateSnapshot(String string) {
        return this.setSnapshot(string);
    }

    public ControllerProperties removeSnapshot(String string) {
        this._mySnapshots.remove(string);
        return this;
    }

    ControllerProperties setSnapshot(String string, String ... stringArray) {
        return this;
    }

    public ControllerProperties saveSnapshot(String string) {
        this.saveSnapshotAs(this.controlP5.papplet.sketchPath(string), string);
        return this;
    }

    public ControllerProperties saveSnapshotAs(String string, String string2) {
        Set<ControllerProperty> set = this._mySnapshots.get(string2);
        if (set == null) {
            return this;
        }
        string = this.getPathWithExtension(this.format, this.controlP5.checkPropertiesPath(string));
        this.format.compile(set, string);
        return this;
    }

    private String getPathWithExtension(PropertiesStorageFormat propertiesStorageFormat, String string) {
        return string.endsWith("." + propertiesStorageFormat.getExtension()) ? string : string + "." + propertiesStorageFormat.getExtension();
    }

    public ControllerProperties getSnapshot(String string) {
        Set<ControllerProperty> set = this._mySnapshots.get(string);
        if (set != null) {
            for (ControllerProperty controllerProperty : set) {
                Controller<?> controller = this.controlP5.getController(controllerProperty.getAddress());
                controller = controller == null ? this.controlP5.getGroup(controllerProperty.getAddress()) : controller;
                ControlP5.invoke(controller, controllerProperty.getSetter(), controllerProperty.getValue());
            }
        }
        return this;
    }

    public ArrayList<String> getSnapshotIndices() {
        return new ArrayList<String>(this._mySnapshots.keySet());
    }

    public boolean load() {
        return this.load(this.controlP5.papplet.sketchPath(defaultName + "." + this.format.getExtension()));
    }

    public boolean load(String string) {
        return this.format.load(this.getPathWithExtension(this.format, this.controlP5.checkPropertiesPath(string)));
    }

    public void setFormat(PropertiesStorageFormat propertiesStorageFormat) {
        this.format = propertiesStorageFormat;
    }

    public void setFormat(String string) {
        if (string.equals("JSON")) {
            this.setFormat(new JSONFormat());
        } else if (string.equals("SERIALIZED")) {
            this.setFormat(new SerializedFormat());
        } else {
            System.out.println("sorry format " + string + " does not exist.");
        }
    }

    public boolean save() {
        System.out.println("save properties using format " + this.format + " (" + this.format.getExtension() + ") " + this.controlP5.papplet.sketchPath(defaultName));
        this.format.compile(this.allProperties.keySet(), this.getPathWithExtension(this.format, this.controlP5.papplet.sketchPath(defaultName)));
        return true;
    }

    public boolean saveAs(String string) {
        this.format.compile(this.allProperties.keySet(), this.getPathWithExtension(this.format, this.controlP5.checkPropertiesPath(string)));
        return true;
    }

    public boolean saveAs(String string, String ... stringArray) {
        string = this.controlP5.checkPropertiesPath(string);
        HashSet<ControllerProperty> hashSet = new HashSet<ControllerProperty>();
        for (ControllerProperty controllerProperty : this.allProperties.keySet()) {
            if (!this.allProperties.containsKey(controllerProperty)) continue;
            HashSet<String> hashSet2 = this.allProperties.get(controllerProperty);
            for (String string2 : hashSet2) {
                for (String string3 : stringArray) {
                    if (!string2.equals(string3)) continue;
                    hashSet.add(controllerProperty);
                }
            }
        }
        this.format.compile(hashSet, this.getPathWithExtension(this.format, string));
        return true;
    }

    public String toString() {
        String string = "";
        string = string + this.getClass().getName() + "\n";
        string = string + "total num of properties:\t" + this.allProperties.size() + "\n";
        for (ControllerProperty object : this.allProperties.keySet()) {
            string = string + "\t" + object + "\n";
        }
        string = string + "total num of sets:\t\t" + this.allSets.size() + "\n";
        for (String string2 : this.allSets) {
            string = string + "\t" + string2 + "\n";
        }
        return string;
    }

    public class SerializedFormat
    implements PropertiesStorageFormat {
        @Override
        public boolean load(String string) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                int n = objectInputStream.readInt();
                logger.info("loading " + n + " property-items. ");
                for (int i = 0; i < n; ++i) {
                    try {
                        ControllerProperty controllerProperty = (ControllerProperty)objectInputStream.readObject();
                        Controller<?> controller = ControllerProperties.this.controlP5.getController(controllerProperty.getAddress());
                        controller = controller == null ? ControllerProperties.this.controlP5.getGroup(controllerProperty.getAddress()) : controller;
                        controller.setId(controllerProperty.getId());
                        try {
                            Method method = controller.getClass().getMethod(controllerProperty.getSetter(), controllerProperty.getType());
                            method.setAccessible(true);
                            method.invoke(controller, controllerProperty.getValue());
                        }
                        catch (Exception exception) {
                            logger.severe(exception.toString());
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        logger.warning("skipping a property, " + exception);
                    }
                }
                objectInputStream.close();
            }
            catch (Exception exception) {
                logger.warning("Exception during deserialization: " + exception);
                return false;
            }
            return true;
        }

        @Override
        public String getExtension() {
            return "ser";
        }

        @Override
        public void compile(Set<ControllerProperty> set, String string) {
            int n = 0;
            int n2 = 0;
            HashSet<ControllerProperty> hashSet = new HashSet<ControllerProperty>();
            for (ControllerProperty object : set) {
                if (object.isActive() && ControllerProperties.this.updatePropertyValue(object)) {
                    ++n;
                    object.setId(object.getController().getId());
                    hashSet.add(object);
                }
                ++n2;
            }
            int n3 = n2 - n;
            try {
                FileOutputStream exception = new FileOutputStream(string);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(exception);
                logger.info("Saving property-items to " + string);
                objectOutputStream.writeInt(n);
                for (ControllerProperty controllerProperty : hashSet) {
                    if (!controllerProperty.isActive()) continue;
                    objectOutputStream.writeObject(controllerProperty);
                }
                logger.info(n + " items saved, " + n3 + " items ignored. Done saving properties.");
                objectOutputStream.flush();
                objectOutputStream.close();
                exception.close();
            }
            catch (Exception exception) {
                logger.warning("Exception during serialization: " + exception);
            }
        }
    }

    private class JSONReader {
        private final PApplet papplet;

        public JSONReader(Object object) {
            if (object instanceof PApplet) {
                this.papplet = (PApplet)object;
            } else {
                this.papplet = null;
                System.out.println("Sorry, argument is not of instance PApplet");
            }
        }

        public Object parse(String string) {
            if (string.indexOf("{") >= 0) {
                return this.get(JSONObject.parse((String)string), new LinkedHashMap());
            }
            return this.get(this.papplet.loadJSONObject(string), new LinkedHashMap());
        }

        Object get(Object object, Object object2) {
            if (object instanceof JSONObject) {
                if (object2 instanceof Map) {
                    Set set = ((JSONObject)object).keys();
                    for (Object e : set) {
                        Cloneable cloneable;
                        Object object3 = ControlP5.invoke(object, "opt", e.toString());
                        if (object3 instanceof JSONObject) {
                            cloneable = new LinkedHashMap();
                            ((Map)object2).put(e.toString(), cloneable);
                            this.get(object3, cloneable);
                            continue;
                        }
                        if (object3 instanceof JSONArray) {
                            cloneable = new ArrayList();
                            ((Map)object2).put(e.toString(), cloneable);
                            this.get(object3, cloneable);
                            continue;
                        }
                        ((Map)object2).put(e.toString(), object3);
                    }
                }
            } else if (object instanceof JSONArray) {
                if (object2 instanceof List) {
                    List list = (List)object2;
                    int n = 0;
                    Object object4 = ControlP5.invoke(object, "opt", n);
                    while (object4 != null) {
                        Cloneable cloneable;
                        if (object4 instanceof JSONArray) {
                            cloneable = new ArrayList();
                            list.add(cloneable);
                            this.get(object4, cloneable);
                        } else if (object4 instanceof JSONObject) {
                            cloneable = new LinkedHashMap();
                            list.add(cloneable);
                            this.get(object4, cloneable);
                        } else {
                            list.add(object4);
                        }
                        object4 = ControlP5.invoke(object, "opt", ++n);
                    }
                } else {
                    System.err.println("JSONReader type mismatch.");
                }
            }
            return object2;
        }
    }

    public class JSONFormat
    implements PropertiesStorageFormat {
        @Override
        public void compile(Set<ControllerProperty> set, String string) {
            long l = System.currentTimeMillis();
            JSONObject jSONObject = new JSONObject();
            for (ControllerProperty controllerProperty : set) {
                if (!controllerProperty.isActive() || !ControllerProperties.this.updatePropertyValue(controllerProperty)) continue;
                controllerProperty.setId(controllerProperty.getController().getId());
                if (!jSONObject.keys().contains(controllerProperty.getAddress())) {
                    jSONObject.setJSONObject(controllerProperty.getAddress(), new JSONObject());
                }
                JSONObject jSONObject2 = jSONObject.getJSONObject(controllerProperty.getAddress());
                String string2 = controllerProperty.getSetter();
                string2 = Character.toLowerCase(string2.charAt(3)) + string2.substring(4);
                if (controllerProperty.getValue() instanceof Number) {
                    if (controllerProperty.getValue() instanceof Integer) {
                        jSONObject2.setInt(string2, ControlP5.i(controllerProperty.getValue()));
                        continue;
                    }
                    if (controllerProperty.getValue() instanceof Float) {
                        jSONObject2.setFloat(string2, ControlP5.f(controllerProperty.getValue()));
                        continue;
                    }
                    if (!(controllerProperty.getValue() instanceof Double)) continue;
                    jSONObject2.setDouble(string2, ControlP5.d(controllerProperty.getValue()));
                    continue;
                }
                if (controllerProperty.getValue() instanceof Boolean) {
                    jSONObject2.setBoolean(string2, ControlP5.b(controllerProperty.getValue()));
                    continue;
                }
                if (controllerProperty.getValue().getClass().isArray()) {
                    Number number;
                    int n;
                    int n2;
                    Object[] objectArray;
                    JSONArray jSONArray = new JSONArray();
                    if (controllerProperty.getValue() instanceof int[]) {
                        objectArray = (int[])controllerProperty.getValue();
                        n2 = objectArray.length;
                        for (n = 0; n < n2; ++n) {
                            number = objectArray[n];
                            jSONArray.append(ControlP5.i(number));
                        }
                    } else if (controllerProperty.getValue() instanceof float[]) {
                        objectArray = (float[])controllerProperty.getValue();
                        n2 = objectArray.length;
                        for (n = 0; n < n2; ++n) {
                            number = Float.valueOf(objectArray[n]);
                            jSONArray.append(ControlP5.f(number));
                        }
                    }
                    jSONObject2.setJSONArray(string2, jSONArray);
                    continue;
                }
                jSONObject2.setString(string2, controllerProperty.getValue().toString());
            }
            jSONObject.save(new File(ControllerProperties.this.getPathWithExtension(this, string)), "");
        }

        @Override
        public String getExtension() {
            return "json";
        }

        @Override
        public boolean load(String string) {
            JSONReader jSONReader = new JSONReader(ControllerProperties.this.controlP5.papplet);
            Map map = ControlP5.toMap(jSONReader.parse(string));
            for (Map.Entry entry : map.entrySet()) {
                String string2 = entry.getKey().toString();
                Controller<?> controller = ControllerProperties.this.controlP5.getController(string2);
                Map map2 = ControlP5.toMap(entry.getValue());
                for (Map.Entry entry2 : map2.entrySet()) {
                    String string3 = entry2.getKey().toString();
                    String string4 = "set" + Character.toUpperCase(string3.charAt(0)) + string3.substring(1);
                    Object v = entry2.getValue();
                    if (v instanceof Number) {
                        ControlP5.invoke(controller, string4, Float.valueOf(ControlP5.f(entry2.getValue())));
                        continue;
                    }
                    if (v instanceof String) {
                        ControlP5.invoke(controller, string4, ControlP5.s(entry2.getValue()));
                        continue;
                    }
                    if (v instanceof float[]) {
                        ControlP5.invoke(controller, string4, new Object[]{(float[])v});
                        continue;
                    }
                    if (v instanceof List) {
                        List list = (List)v;
                        float[] fArray = new float[list.size()];
                        for (int i = 0; i < list.size(); ++i) {
                            fArray[i] = ControlP5.f(list.get(i));
                        }
                        ControlP5.invoke(controller, string4, new Object[]{fArray});
                        continue;
                    }
                    ControlP5.invoke(controller, string4, entry2.getValue());
                }
            }
            return false;
        }
    }

    class XMLFormat
    implements PropertiesStorageFormat {
        XMLFormat() {
        }

        @Override
        public void compile(Set<ControllerProperty> set, String string) {
            System.out.println("Dont use the XMLFormat yet, it is not fully implemented with 0.5.9, use SERIALIZED instead.");
            System.out.println("Compiling with XMLFormat");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            stringBuffer.append("<properties name=\"" + string + "\">\n");
            for (ControllerProperty controllerProperty : set) {
                if (!controllerProperty.isActive()) continue;
                ControllerProperties.this.updatePropertyValue(controllerProperty);
                stringBuffer.append(this.getXML(controllerProperty));
            }
            stringBuffer.append("</properties>");
            ControllerProperties.this.controlP5.papplet.saveStrings(string, PApplet.split((String)stringBuffer.toString(), (String)"\n"));
            System.out.println("saving xml, " + string);
        }

        @Override
        public String getExtension() {
            return "xml";
        }

        @Override
        public boolean load(String string) {
            String string2;
            try {
                string2 = PApplet.join((String[])ControllerProperties.this.controlP5.papplet.loadStrings(string), (String)"\n");
            }
            catch (Exception exception) {
                logger.warning(string + ", file not found.");
                return false;
            }
            System.out.println("loading xml \n" + string2);
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                InputSource inputSource = new InputSource();
                inputSource.setCharacterStream(new StringReader(string2));
                Document document = documentBuilder.parse(inputSource);
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("property");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String string3 = this.getElement(element, "address");
                    String string4 = this.getElement(element, "setter");
                    String string5 = this.getElement(element, "type");
                    String string6 = this.getElement(element, "value");
                    try {
                        System.out.print("setting controller " + string3 + "   ");
                        Controller<?> controller = ControllerProperties.this.controlP5.getController(string3);
                        controller = controller == null ? ControllerProperties.this.controlP5.getGroup(string3) : controller;
                        System.out.println(controller);
                        try {
                            Class<?> clazz = this.getClass(string5);
                            System.out.println(string5 + " / " + clazz);
                            Method method = controller.getClass().getMethod(string4, clazz);
                            method.setAccessible(true);
                            method.invoke(controller, this.getValue(string6, string5, clazz));
                        }
                        catch (Exception exception) {
                            logger.severe(exception.toString());
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        logger.warning("skipping a property, " + exception);
                    }
                }
            }
            catch (SAXException sAXException) {
                logger.warning("SAXException, " + sAXException);
                return false;
            }
            catch (IOException iOException) {
                logger.warning("IOException, " + iOException);
                return false;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                logger.warning("ParserConfigurationException, " + parserConfigurationException);
                return false;
            }
            return true;
        }

        private Object getValue(String string, String string2, Class<?> clazz) {
            if (clazz == Integer.TYPE) {
                return Integer.parseInt(string);
            }
            if (clazz == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Boolean.TYPE) {
                return Boolean.parseBoolean(string);
            }
            if (clazz.isArray()) {
                System.out.println("this is an array: " + string2 + ", " + string + ", " + clazz);
                for (int i = 0; string2.charAt(i) == '[' && i < string2.length(); ++i) {
                }
            } else {
                System.out.println("is array? " + clazz.isArray());
            }
            return string;
        }

        private Class<?> getClass(String string) {
            if (string.equals("int")) {
                return Integer.TYPE;
            }
            if (string.equals("float")) {
                return Float.TYPE;
            }
            if (string.equals("String")) {
                return String.class;
            }
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.warning("ClassNotFoundException, " + classNotFoundException);
                return null;
            }
        }

        private String getElement(Element element, String string) {
            NodeList nodeList = element.getElementsByTagName(string);
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getChildNodes();
            return nodeList2.item(0).getNodeValue();
        }

        public String getXML(ControllerProperty controllerProperty) {
            String string = "\t<property>\n";
            string = string + "\t\t<address>" + controllerProperty.getAddress() + "</address>\n";
            string = string + "\t\t<class>" + CP.formatGetClass(controllerProperty.getController().getClass()) + "</class>\n";
            string = string + "\t\t<setter>" + controllerProperty.getSetter() + "</setter>\n";
            string = string + "\t\t<getter>" + controllerProperty.getGetter() + "</getter>\n";
            string = string + "\t\t<type>" + CP.formatGetClass(controllerProperty.getType()) + "</type>\n";
            string = string + "\t\t<value>" + this.cdata(0, controllerProperty.getValue().getClass()) + (controllerProperty.getValue().getClass().isArray() ? CP.arrayToString(controllerProperty.getValue()) : controllerProperty.getValue()) + this.cdata(1, controllerProperty.getValue().getClass()) + "</value>\n";
            string = string + "\t</property>\n";
            return string;
        }

        private String cdata(int n, Class<?> clazz) {
            if (clazz == String.class || clazz.isArray()) {
                return n == 0 ? "<![CDATA[" : "]]>";
            }
            return "";
        }
    }

    static interface PropertiesStorageFormat {
        public void compile(Set<ControllerProperty> var1, String var2);

        public boolean load(String var1);

        public String getExtension();
    }
}

